/*
 * Decompiled with CFR 0.152.
 */
package com.djinfinite.manors_bounty.items;

import com.djinfinite.manors_bounty.items.FoodEffect;
import com.djinfinite.manors_bounty.items.FoodEffectType;
import com.djinfinite.manors_bounty.items.FoodType;
import com.djinfinite.manors_bounty.items.IFoodItem;
import com.djinfinite.manors_bounty.registries.ModMobEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class Pineapple
extends Item
implements IFoodItem {
    protected Pineapple(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public FoodType getFoodType() {
        return FoodType.PINEAPPLE;
    }

    public static class Pastries
    extends Pineapple {
        public Pastries() {
            super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(5).m_38758_(0.6f).m_38767_()));
        }

        @Override
        public FoodEffectType getFoodEffectType() {
            return FoodEffectType.C;
        }

        @Override
        public FoodEffect getFoodEffect() {
            return FoodEffect.C.of().addEffect((MobEffect)ModMobEffects.SUMMER_HEATWAVE.get());
        }
    }

    public static class Paleteria
    extends Pineapple {
        public Paleteria() {
            super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(10).m_38758_(0.2f).m_38767_()));
        }

        @Override
        public FoodEffectType getFoodEffectType() {
            return FoodEffectType.C;
        }

        @Override
        public ItemStack usedWhenNotInCooldown(Level level, Player player, ItemStack itemStack) {
            if (this.getFoodEffect().apply((LivingEntity)player)) {
                this.cooldown(player, this);
            }
            return this.returnItem(player, itemStack, Items.f_42398_.m_7968_());
        }

        @Override
        public ItemStack usedWhenInCooldown(Level level, Player player, ItemStack itemStack) {
            return this.returnItem(player, itemStack, Items.f_42398_.m_7968_());
        }

        @Override
        public FoodEffect getFoodEffect() {
            return FoodEffect.C.of().addEffect((MobEffect)ModMobEffects.SUMMER_HEATWAVE.get());
        }
    }

    public static class Pie
    extends Pineapple {
        public Pie() {
            super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(5).m_38758_(0.35f).m_38767_()));
        }

        @Override
        public FoodEffectType getFoodEffectType() {
            return FoodEffectType.C;
        }

        @Override
        public FoodEffect getFoodEffect() {
            return FoodEffect.C.of().addEffect((MobEffect)ModMobEffects.SUMMER_HEATWAVE.get());
        }
    }

    public static class Juice
    extends Pineapple {
        public Juice() {
            super(new Item.Properties().m_41487_(16).m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.1f).m_38765_().m_38767_()));
        }

        @NotNull
        public UseAnim m_6164_(@NotNull ItemStack itemstack) {
            return UseAnim.DRINK;
        }

        @Override
        public ItemStack usedWhenNotInCooldown(Level level, Player player, ItemStack itemStack) {
            if (this.getFoodEffect().apply((LivingEntity)player)) {
                this.cooldown(player, this);
            }
            return this.returnCup(player, itemStack);
        }

        @Override
        public ItemStack usedWhenInCooldown(Level level, Player player, ItemStack itemStack) {
            return this.returnCup(player, itemStack);
        }

        @Override
        public FoodEffectType getFoodEffectType() {
            return FoodEffectType.B;
        }

        @Override
        public FoodEffect getFoodEffect() {
            return FoodEffect.B.of().addEffect((MobEffect)ModMobEffects.SUMMER_HEATWAVE.get(), 70.0);
        }
    }

    public static class Sliced
    extends Pineapple {
        public Sliced() {
            super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38767_()));
        }

        @Override
        public FoodEffectType getFoodEffectType() {
            return FoodEffectType.A;
        }

        @Override
        public FoodEffect getFoodEffect() {
            return FoodEffect.A.of().addEffect((MobEffect)ModMobEffects.SUMMER_HEATWAVE.get(), 25.0);
        }
    }
}

